/******************************************
 * 斜方蹴射
 * created by 悠遊自的♪
 * url : http://homepage3.nifty.com/zi_zas/
 ******************************************/
enchant();

//////////////////////////////// 定数 /////
var SCR_W = 480;
var SCR_H = 480;
var FPS = 60;
var BALL_SIZE = 20;     // ボールのサイズ
var INIT_BALL_X = 20;   // ボールの初期位置X
var INIT_BALL_Y = SCR_H - 80 - BALL_SIZE;   // ボールの初期位置Y
var SPD_Y_MAX = 5.0;    // Y方向移動速度の最大
var GRAVITY = 0.3;      // 重力
var PLAY_TIME = 3000;   // プレイ時間(フレーム)
var MAX_POW_GAGE = 100; // パワー最大値(ゲージ値)
var POW_RATIO_X = 0.15;  // ゲージ値→速度の変換係数X
var POW_RATIO_Y = 0.17;  // ゲージ値→速度の変換係数Y
var WIND_RATIO = 0.02; // 風力→速度の変換係数
var POW_SPD = 1.5;  // ゲージの上昇速度
var GROUND_HEIGHT = SCR_H - 80; // 地面の高さ
var TARGET_W = 20; // 的の大きさ
var TARGET_H = 100;
var MAX_WIND_POW = 9;  // 風の最大値(-max～+maxでランダム決定)
var AIR_SCORE_RATIO = 0.5; // 滞空時間→獲得点数の変換係数

// テキスト関連
var TEXT_POS_SCORE_X = 10; // テキスト基準位置：スコア
var TEXT_POS_SCORE_Y = 10; 
var TEXT_POS_WIND_X = 10; // テキスト基準位置：風
var TEXT_POS_WIND_Y = 45;
var TEXT_POS_TIME_X = 340; // テキスト基準位置：タイマー
var TEXT_POS_TIME_Y = 10;

// 演出時間
var TIME_DIR_TIMEUP = 90;  // 演出時間：タイムアップ
var TIME_DIR_HIT = 60;      // 演出時間：ヒット
var TIME_DIR_MISS = 30;      // 演出時間：ミス

////////////////////// グローバル変数 /////
var g_game;             // ゲーム

// リソースのパス
var g_res = {
    "kick"      : "kick.wav",
    "pi"        : "pi.wav",
    "hit"       : "hit.wav",
    "face"      : "face.png",
    "end"       : "end.wav", 
    "bgm"       : "sky.mp3"
};

////////////////////////// クラス定義 /////

//=========================================
// ボール
//=========================================
Ball = Class.create(Sprite, {
    // コンストラクタ
    initialize : function(){
        Sprite.call(this, BALL_SIZE, BALL_SIZE);
        this.image = g_game.assets[g_res.face];
        this.frame = 0;
        this.x = 0;
        this.y = 0;
        this.spd_x = 0;
        this.spd_y = 0;
        this.wind = 0;
        this.state = 0; // 0=セット状態、1=蹴られ状態、2=衝突(ミス)状態
    },

    // 更新
    onenterframe : function(){
        if(this.state == 1){
            this.spd_x += this.wind;
            this.x += this.spd_x;
            
            this.spd_y += GRAVITY;
            this.y += this.spd_y;
            if(GROUND_HEIGHT < this.y + this.height){
                this.y = GROUND_HEIGHT - this.height;
                this.state = 2; // 停止
            }
        }
    },
    
    // セットアップ
    setup : function(x, y){
        this.x = x;
        this.y = y;
        this.spd_x = 0;
        this.spd_y = 0;
        this.frame = 0;
        this.state = 0;
    },
    
    // 蹴る
    kick : function(powX, powY, wind){
        this.spd_x = powX * POW_RATIO_X;
        this.spd_y = -powY * POW_RATIO_Y;
        this.wind = wind * WIND_RATIO;
        this.state = 1;
        this.frame = 1;
    },
    
    // 停止させる
    stop : function(){
        this.state = 2;  
    },
    
    // 停止している？
    isStop : function(){
        return this.state == 2;
    },
});

//=========================================
// ターゲット
//=========================================
Target = Class.create(Sprite, {
    // コンストラクタ
    initialize : function(){
        Sprite.call(this, TARGET_W, TARGET_H);
        this.x = 0;
        this.y = 0;
        this.backgroundColor = "#00f";
    },

    // 更新
    onenterframe : function(){
    },
    
    // セットアップ
    setup : function(x, y){
        this.x = x;
        this.y = y;
    },
});

//=========================================
// シーン：タイトル
//=========================================
SceneTitle = Class.create(Scene, {
    // コンストラクタ
    initialize : function(){
        Scene.call(this);
        this.createDisplay();
    },

    // 更新
    onenterframe : function(){
    },
    
    // タッチ
    ontouchstart : function(){
        // ゲーム開始
        g_game.assets[g_res.pi].play();
        g_game.replaceScene(new SceneMainGame());
    },
    
    // 画面の作成
    createDisplay : function(){
        this.addChild(createLabel("斜方蹴射", 120, 180, 60, "#f00"));
        this.addChild(createLabel("タッチでスタート", 120, 250, 30, "#000"));
        this.addChild(createLabel("Created by 悠遊自的♪", SCR_W-220, SCR_H-30, 20, "#000"));
    },
});

//=========================================
// シーン：メインゲーム画面
//=========================================
SceneMainGame = Class.create(Scene, {
    // コンストラクタ
    initialize : function(){
        Scene.call(this);
        this.labelScore = null;     // スコアテキスト
        this.labelTime = null;      // タイマーテキスト
        this.labelWind = null;      // 風力テキスト
        this.labelHit = null;       // ヒットテキスト
        this.labelAir = null;       // 滞空時間(獲得点数)テキスト
        this.powX = 0; // Xパワー
        this.powY = 0; // Yパワー
        this.time = PLAY_TIME;  // 残り時間
        this.dirTimer = 0; // 演出タイマー
        this.mode = 0;  // モード：0=X軸決定待ち、1=Y軸決定待ち、2=ボール移動中、3=ヒット演出中、4=時間切れ演出中、5=ミス演出中
        this.update = this.updateXPow; // 更新関数
        this.wind = 0;  // 風の強さ
        this.airTime = 0; // 滞空時間

        // ボール
        this.ball = new Ball();
        this.addChild(this.ball);
        
        // ターゲット
        this.target = new Target();
        this.addChild(this.target);
        
        // 画面生成
        this.createDisplay();
        
        // ボールなどを初期状態にする
        this.setup();
        
        // BGM再生
        g_game.assets[g_res.bgm].play();
        g_game.assets[g_res.bgm].src.loop = true;
    },

    // 更新
    onenterframe : function(){
        if(this.update){
            this.update();
        }
    },
    
    // タッチ
    ontouchstart : function(){
        switch(this.mode){
            case 0:
                g_game.assets[g_res.pi].play();
                this.mode = 1;
                this.update = this.updateYPow;
                break;
            case 1:
                g_game.assets[g_res.kick].play();
                this.ball.kick(this.powX, this.powY, this.wind);
                this.airTime = 0;
                this.labelAir.visible = true;
                
                this.mode = 2;
                this.update = this.updateBall;
                break;
        }
    },
    
    // 画面の作成
    createDisplay : function(){
        // 地面
        this.addChild(createRect(0, SCR_H-80, SCR_W, 80, "#800"));
        
        // ゲージ背景
        this.addChild(createRect(0, SCR_H-40, SCR_W, 40, "#000"));
        
        // ゲージ
        this.gageX = createRect(2, SCR_H-38, SCR_W-4, 18, "#f00");
        this.addChild(this.gageX);
        this.gageY = createRect(2, SCR_H-19, SCR_W-4, 18, "#0f0");
        this.addChild(this.gageY);
        
        this.addChild(createLabel("Score", TEXT_POS_SCORE_X, TEXT_POS_SCORE_Y, 30, "#f00"));
        this.labelScore = new createLabel("0", TEXT_POS_SCORE_X+90, TEXT_POS_SCORE_Y, 30, "#000");
        this.addChild(this.labelScore);

        this.addChild(createLabel("風向", TEXT_POS_WIND_X, TEXT_POS_WIND_Y, 30, "#f00"));        
        this.labelWind = new createLabel("0", TEXT_POS_WIND_X+75, TEXT_POS_WIND_Y, 30, "#000");
        this.addChild(this.labelWind);
        
        this.addChild(createLabel("Time", TEXT_POS_TIME_X, TEXT_POS_TIME_Y, 30, "#f00"));
        this.labelTime = new createLabel("0", TEXT_POS_TIME_X+75, TEXT_POS_TIME_Y, 30, "#000");    
        this.addChild(this.labelTime);
        
        // タイムアップテキスト
        this.labelTimeUp = createLabel("Time up!", 130, 180, 60, "#f00");    
        this.labelTimeUp.visible = false;
        this.addChild(this.labelTimeUp);
        
        // ヒットテキスト
        this.labelHit = createLabel("Hit!", 190, 180, 60, "#f00");
        this.labelHit.visible = false;
        this.addChild(this.labelHit);
        
        // 滞空時間テキスト
        this.labelAir = createLabel("+", TEXT_POS_SCORE_X+150, TEXT_POS_SCORE_Y, 30, "#00f");
        this.labelAir.visible = false;
        this.addChild(this.labelAir);
        
    },
    
    // UI更新
    updateDisplay : function(){
        // スコア
        if(this.labelScore){
            this.labelScore.text = g_game.score;
        }
        
        // 残り時間
        if(this.labelTime){
            this.labelTime.text = Math.floor(this.time / 10);
        }
        
        // 風向き
        if(this.labelWind){
            this.labelWind.text = this.wind;
        }
        
        // Xゲージ
        if(this.gageX){
           this.gageX.width = (SCR_W-2)/MAX_POW_GAGE * this.powX;
        }
        // Yゲージ
        if(this.gageY){
            this.gageY.width = (SCR_W-2)/MAX_POW_GAGE * this.powY;
        }
    },

    // 更新：X軸決定待ち
    updateXPow : function(){
        this.updateTimer();
        
        this.powX += POW_SPD;
        if(MAX_POW_GAGE < this.powX){
            this.powX = 0;    
        }
        
        this.updateDisplay();
    },
    
    // 更新：Y軸決定待ち
    updateYPow : function(){
        this.updateTimer();
        
        this.powY += POW_SPD;
        if(MAX_POW_GAGE < this.powY){
            this.powY = 0;
        }
        
        this.updateDisplay();
    },
    
    // 更新：ボール移動中
    updateBall : function(){
        // 滞空時間更新
        this.airTime++;
        this.labelAir.text = "+" + Math.floor(this.airTime * AIR_SCORE_RATIO);
        
        // ヒット！
        if(this.ball.intersect(this.target)){
            this.dirHit();
        }
        // ヒットしてないのに停止状態＝ミス
        else if(this.ball.isStop()){
            this.dirMiss();
        }
    },
    
    // 更新：ヒット演出中
    updateHit : function(){
        this.dirTimer--;
        if(this.dirTimer <= 0){
            this.setup();
            this.mode = 0;
            this.update = this.updateXPow;
            this.labelHit.visible = false;
            this.labelAir.visible = false;
        }
    },
    
    // 更新：時間切れ演出中
    updateTimeUp : function(){
        this.dirTimer--;
        if(this.dirTimer <= 0){
            // リザルト画面へ移行
            g_game.replaceScene(new SceneResult());
        }
    },
    
    // 更新：ミス演出中
    updateMiss : function(){
        this.dirTimer--;
        if(this.dirTimer <= 0){
            this.setup();
            this.mode = 0;
            this.update = this.updateXPow;
            this.labelAir.visible = false;
        }
    },

    // タイマー更新
    updateTimer : function(){
        this.time--;    
        if(this.time <= 0){
            this.time = 0;
            this.dirTimeUp();
        }
    },

    // 演出：ヒット
    dirHit : function(){
        // 加点
        var addScore = Math.floor(this.airTime * AIR_SCORE_RATIO);
        g_game.score += addScore;
        
        g_game.assets[g_res.hit].play();
        
        this.ball.stop();
        this.mode = 3;
        this.update = this.updateHit;
        this.dirTimer = TIME_DIR_HIT;
        this.labelHit.visible = true;
    },

    // 演出：時間切れ
    dirTimeUp : function(){
        this.mode = 4;
        this.update = this.updateTimeUp;
        g_game.assets[g_res.end].play();
        g_game.assets[g_res.bgm].stop();
        
        this.labelTimeUp.visible = true;
        this.dirTimer = TIME_DIR_TIMEUP;
    },

    // 演出：ミス
    dirMiss : function(){
        this.mode = 5;
        this.update = this.updateMiss;
        this.dirTimer = TIME_DIR_MISS;
    },
    
    // ボールやゲージの状態を初期状態に戻す
    setup : function(){
        this.ball.setup(INIT_BALL_X, INIT_BALL_Y);
        this.powX = 0;
        this.powY = 0;
        this.target.setup(200 + rndInt(SCR_W-250), 80 + rndInt(GROUND_HEIGHT-this.target.height-80));
        this.wind = Math.floor(rndFloat(-MAX_WIND_POW, MAX_WIND_POW));
    },
});

//=========================================
// シーン：リザルト
//=========================================
SceneResult = Class.create(Scene, {
    // コンストラクタ
    initialize : function(){
        Scene.call(this);
        this.backgroundColor = "#000";
        this.createDisplay();
    },

    // 更新
    onenterframe : function(){
    },
    
    // タッチ
    ontouchstart : function(){
        // タイトル画面へ移行
        g_game.assets[g_res.pi].play();
        g_game.replaceScene(new SceneTitle());
    },
    
    // 画面の作成
    createDisplay : function(){
        this.addChild(createLabel("Result", 150, 130, 60, "#ff0"));
        this.addChild(createLabel(""+g_game.score + " pt", 200, 240, 40, "#fff"));
    },
});

//////////////////////////////// 関数 /////

//=========================================
// エントリーポイント
//=========================================
window.onload = function(){
    // ゲームオブジェクトの初期化
    g_game = new Game(SCR_W, SCR_H);
    g_game.fps = FPS;
    g_game.score = 0;
    g_game.time = 0;
    g_game.rootScene.backgroundColor = "#8ff";
    
    // プリロード
    for(var i in g_res){
        g_game.preload(g_res[i]);
    };
    // ロード完了
    g_game.onload = function(){
        // タイトルシーンの作成
        g_game.pushScene(new SceneTitle());
    };
    g_game.start();
};

//=========================================
// 矩形を作成する
//=========================================
function createRect(x, y, w, h, col){
    var rect = new Entity();
    rect.x = x;
    rect.y = y;
    rect.width = w;
    rect.height = h;
    rect.backgroundColor = col;
    return rect;
};

//=========================================
// ラベルを作成する
//=========================================
function createLabel(text, x, y, size, col){
    var label = new Label(text);
    label.x = x;
    label.y = y;
    label.font = size + "px monospace";
    label.color = col;
    return label;
};

//=========================================
// 0以上sup未満の乱数を得る
//=========================================
function rndInt(sup){
    return Math.floor(Math.random() * sup);
};

//=========================================
// min以上max未満の乱数を得る(浮動小数版)
//=========================================
function rndFloat(min, max){
    return Math.random() * (max-min) + min;
};

//=========================================
// ユーザー環境の取得
//=========================================
function getUa() {
    if ((navigator.userAgent.indexOf('iPhone') > 0 && navigator.userAgent.indexOf('iPad') == -1) || navigator.userAgent.indexOf('iPod') > 0 ) {
        return 'iPhone'; 
    } else if(navigator.userAgent.indexOf('iPad') > 0) {
        return 'iPad';
    } else if(navigator.userAgent.indexOf('Android') > 0) {
        return 'Android';
    } else return false;
}
