enchant();
window.onload = function() {
    var floor, label, x, y, c = 0,
        score = 0;
    var Block = Class.create(PhyBoxSprite, { //ブロッククラス
        initialize: function(x, y, angle) { //物理シミュレーション対応スプライトを継承
            PhyBoxSprite.call(this, 8, 32, enchant.box2d.DYNAMIC_SPRITE, 1.0, 0.8, 0.2, true);
            this.image = game.assets['block.png'];
            this.x = x;
            this.y = y;
            this.angle = angle;
            game.rootScene.addChild(this);
        }
    });
    var Character = Class.create(PhyCircleSprite, { //キャラクタークラス
        initialize: function(x, y, frame, scale) { //物理シミュレーション対応スプライトを継承
            PhyCircleSprite.call(this, 8, enchant.box2d.DYNAMIC_SPRITE, 1.0, 0.3, 0.2, true);
            this.image = game.assets['graphic.png'];
            this.x = x;
            this.y = y;
            this.frame = frame;
            this.scaleX = scale;
            game.rootScene.addChild(this);
        },
        disappear: function() { //tl.enchant.jsを使って小さくなって消える
            return this.tl.scaleTo(0, 60, enchant.Easing.BOUNCE_EASEIN).then(function() {
                this.destroy();
            });
        }
    });
    var Player = Class.create(Character, { //プレイヤークラス
        initialize: function(x, y) {
            Character.call(this, x, y, 3, -1);
        }
    });
    var Enemy = Class.create(Character, { //敵キャラクラス
        initialize: function(x, y) {
            Character.call(this, x, y, 4, 1);
        },
        onenterframe: function() {
            if (Math.abs(this.angle) > 90) //傾いて一定時間経ったら消える
            this.disappear().then(function() {
                score++;
            });
        }
    });
    var generate = function(Constructor, arr) { //ブロックを配置するための便利関数
            for (var i = 0, l = arr.length; i < l; i += 3) new Constructor(arr[i], arr[i + 1] - 80, arr[i + 2]);
        };
    game = new Game(320, 320);
    game.preload('map2.gif', 'graphic.png', 'block.png', 'avatarBg1.png', 'avatarBg2.png', 'avatarBg3.png');
    game.onload = function() {
        bg = new AvatarBG(3); //avatar.enchant.jsで奇麗な背景をつくる
        bg.y = 80;
        bg.x = 300;
        bg.addEventListener('enterframe', function() {
            this.x = -game.rootScene.x - 8;
            this.scroll(game.rootScene.x + 8)
        });
        game.rootScene.addChild(bg);
        var physicsWorld = new PhysicsWorld(0, 9.8); //物理シミュレーション世界を生成。重力加速度は9.8
        for (var i = -5; i < 40; i++) { //床を作成
            floor = new PhyBoxSprite(16, 16, enchant.box2d.STATIC_SPRITE, 1.0, 0.5, 0.3, true);
            floor.image = game.assets['map2.gif'];
            floor.x = i * 16;
            floor.y = game.height - 16 - 80;
            game.rootScene.addChild(floor);
        }
        var player = new Player(160, game.height - 32 - 80); //プレイヤーと壁、敵キャラを配置
        generate(Enemy, [432, 288, 0, 432, 248, 0, 457, 288, 0, 457, 208, 0, 482, 288, 0, 482, 248, 0]);
        generate(Block, [426, 272, 0, 450, 272, 0, 450, 232, 0, 438, 252, 90, 462, 212, 90, 486, 252, 90, 474, 272, 0, 474, 232, 0, 498, 272, 0, ]);
        game.rootScene.backgroundColor = '#000000'
        game.rootScene.x = -300;
        game.rootScene.tl.moveTo(0, 0, 90, enchant.Easing.LINEAR).then(function() {
            game.rootScene.addChild(label = new Label('')); //スコア表示
            game.rootScene.addEventListener('enterframe', function() {
                label.color = "#ffffff";
                label.text = score + '体の敵ドロイドを倒した';
                this.x = -(label.x = player.x) + this.width / 2;
                physicsWorld.step(game.fps); //物理世界の時間を進める
            });
            player.addEventListener('touchstart', function(e) {
                x = e.x;
                y = e.y; //緑ドロイドをドラッグ開始
            });
            player.addEventListener('touchend', function(e) { //ドラッグしてから指を離した!
                this.applyImpulse(new b2Vec2((x - e.x) / 20, (y - e.y) / 20));
                this.addEventListener('enterframe', function() {
                    if (this.vx < 0.02) c++;
                    if (c > 60 || this.y > game.height) this.disappear().then(function() {
                        game.end(score, label.text);
                    });
                });
            });
        });
    };
    game.start(); //ゲーム開始
};
