enchant();

// enchant.jsのSurfaceクラスは、HTML5のcanvasと同じ働きをします
// canvasを使用すると画面に直線や円など好きな図形を描くことが出来ます

window.onload = function() {
    var game = new Game(320, 320);
    game.onload = function(){
        //Spriteを作ります
        sprite = new Sprite(320,320);        
        //Surfaceを作ります
        surface = new Surface(320,320);
        
        //spriteのimageにsurfaceを代入します
        sprite.image = surface;
        
        //コンテキストを取得します
        context = surface.context;
        
        //以下、HTML5のcanvasと同じように使えます
        context.beginPath(); 	//パスを開始
        

        //(0,50)から(0,200)までの間にグラデーションを設定
        var grad  = context.createLinearGradient(0,50, 0,200);

        //赤からグラデーション開始
        grad.addColorStop(0,'rgb(255,  0, 0)'); 

        //青でグラデーション終了
        grad.addColorStop(1,'rgb(  0,  0,255)'); 
        context.fillStyle = grad; 
        
        //(110,50)を左上の座標として、幅80×高さ150の長方形を描く
        context.rect(110,50,80,150);
        context.fill();
        
        context.closePath();	//パスを終了
        context.stroke();
        //シーンにサーフェスを追加する
        game.rootScene.addChild(sprite); 
    }
    game.start();
}