enchant();

var Q=[
"パンダは不安になるとどうする？,吠える,丸くなる,木に登る,毛をむしる,2,",
"花火に色がつくようになったのは何時代？,室町時代,江戸時代,明治時代,大正時代,2",
"ペンギンが寒さをしのぐ方法は？,羽根を動かす,走る,泳ぐ,おしくらまんじゅう,3",
"鏡餅の上にのっているカンキツは何？,ダイダイ,ミカン,ハッサク,キンカン,0",
"キリンの１日の睡眠時間はおよそどのくらい？,8時間,6時間,3時間,1時間,3",
"一番腐りやすいお肉はどれ？,牛肉,豚肉,鶏肉,羊肉,2",
"陸生肉食恐竜ティラノサウルスの推定体重は？, 1トン,3トン,5トン,7トン,3",
"月は1年間で地球からどのくらい遠ざかっている？,3.8cm,22.5cm,50.3cm,117.8cm,0",
"イカの心臓はいくつある？,1個,2個,3個,4個,2",
"光る仲間がいる生物はどれ？,ミミズ,ハダカデバネズミ,サバ,カメムシ,0"
];

//メインプログラム
window.onload = function() {
    //Gameオブジェクトの生成
    var game = new Game(320, 320);
    
    //オブジェクト
    var score = 0;
    var qIndex = 0;
    var qLabel;
    var aButton = new Array(4);
    var aTag;
    
    //画像の読み込み
    game.preload("window.png", "goukaku.png", "fugoukaku.png");
    
    //ボタンの追加
    function addButton(tag,text, x, y) {
        var button = new Button(text, "light");
        button.tag = tag;
        button.font = "20px monospace";
        button.moveTo(x, y);
        button.ontouchend = function() {
            if (this.tag == aTag) score += 10;
            nextQuestion();
        }
        return button;
    }
    
    //次の質問
    function nextQuestion() {
        if (qIndex<10) {
            var data=Q[qIndex].split(",");
            qLabel.text = data[0];
            aButton[0].text = data[1];
            aButton[1].text = data[2];
            aButton[2].text = data[3];
            aButton[3].text = data[4];
            aTag = data[5];
            qIndex++;
        } else {
            result();
        }
    }
    
    //結果
    function result() {
        //シーンの生成
        var scene = new Scene();
        scene.backgroundColor = "rgb(255, 255, 255)";
        
        //合格・不合格の生成
        var hanko = new Sprite();
        if (score >= 80) {
            hanko.image = game.assets["goukaku.png"];
        } else {
            hanko.image = game.assets["fugoukaku.png"];
        }
        hanko.moveTo(74, 15);
        hanko.width = 172;
        hanko.height = 172;
        scene.addChild(hanko);
        
        //正解率の生成
        var label = new Label();
        label.text="正解率" + score + "%";
        label.font = "bold 24px monospace";
        label.y=240;
        label.width = 320;
        label.textAlign = "center";
        scene.addChild(label);
        game.pushScene(scene);
    }    
    
    //ロード完了時の処理
    game.onload = function(){
        //ウィンドウの生成
        var window = new Sprite();
        window.image = game.assets["window.png"];
        window.moveTo(15, 15);
        window.width = 290;
        window.height = 120;
        game.rootScene.addChild(window);
        
        //質問ラベルの生成
        qLabel = new Label();
        qLabel.color = "rgb(255, 255, 255)";
        qLabel.font = "24px monospace";
        qLabel.moveTo(25, 32);
        qLabel.width = 260;
        game.rootScene.addChild(qLabel);
        
        //解答ボタンの生成
        for (var i=0; i<4; i++) {
            aButton[i] = addButton(""+i,"", 20, 150+42*i);     
            aButton[i].width = 260;
            aButton[i].height = 30;
            game.rootScene.addChild(aButton[i]);
        }
        
        //次の質問
        nextQuestion();
    }
        
    //ゲーム開始
    game.start();
}