enchant();
//Class Definitions
// Player class
var Player = enchant.Class.create(enchant.Sprite, {
    initialize: function(x, y){
        enchant.Sprite.call(this, 16, 16);
        this.image = game.assets['graphic.png'];
        this.x = x; 
        this.y = y; 
        this.frame = 0;
        game.rootScene.addEventListener('touchstart',
                function(e){ player.y = e.y; game.touched = true; });
        game.rootScene.addEventListener('touchend',
                function(e){ player.y = e.y; game.touched = false; });
        game.rootScene.addEventListener('touchmove',
                function(e){ player.y = e.y; });
        this.addEventListener('enterframe', function(){
            if(game.touched && game.frame % 3 === 0){     
                // Fire automatically every 3 frames
                var s = new PlayerShoot(this.x, this.y); }
        });        
        game.rootScene.addChild(this);
    }
});

//Enemy class
var Enemy = enchant.Class.create(enchant.Sprite, {
    initialize: function(x, y){
        enchant.Sprite.call(this, 16, 16);
        this.image = game.assets['graphic.png'];
        this.x = x; 
        this.y = y; 
        this.frame = 3; 
        this.direction = Math.PI; 
        this.moveSpeed = 3;
		
        // Define enemy movement
		this.addEventListener('enterframe', function(){
			this.x += this.moveSpeed * Math.cos(this.direction);
			this.y += this.moveSpeed * Math.sin(this.direction);
			
            // Disappear when outside of screen
            if(this.y > 320 || this.x > 320 || this.x < -this.width || this.y < -this.height){
                this.remove();
            }else if(this.age % 10 === 0){ // Fire every 10 frames
                var s = new EnemyShoot(this.x, this.y);
            }

        });
        
		game.rootScene.addChild(this);
	},
    remove: function(){
        game.rootScene.removeChild(this);
        delete enemies[this.key]; 
        delete this;
    }
});

// Shoot class
var Shoot = enchant.Class.create(enchant.Sprite, {
    initialize: function(x, y, direction){
        enchant.Sprite.call(this, 16, 16);
        this.image = game.assets['graphic.png'];
        this.x = x; 
        this.y = y; 
        this.frame = 1;
        this.direction = direction; 
        this.moveSpeed = 10;
        this.addEventListener('enterframe', function(){ // Bullets fire straight in a pre-determined direction
            this.x += this.moveSpeed * Math.cos(this.direction);
            this.y += this.moveSpeed * Math.sin(this.direction);
            if(this.y > 320 || this.x > 320 || this.x < -this.width || this.y < -this.height){
                this.remove();
            }
        });
        game.rootScene.addChild(this);
    },
    remove: function(){ 
        game.rootScene.removeChild(this); 
        delete this;
    }
});

// PlayerShoot class
var PlayerShoot = enchant.Class.create(Shoot, { // Succeeds bullet class
    initialize: function(x, y){
        Shoot.call(this, x, y, 0);
        this.addEventListener('enterframe', function(){
    		// Judges whether or not player’s bullets have hit enemy
    		for(var i in enemies){
        		if(enemies[i].intersect(this)){
            		// Eliminates enemy if hit
            		this.remove(); 
            		enemies[i].remove();
            		//Adds to score
            		game.score += 100;
        		}
    		}
		});
    }
});

// Class for enemy bullets
var EnemyShoot = enchant.Class.create(Shoot, { // Succeeds bullet class
    initialize: function(x, y){
        Shoot.call(this, x, y, Math.PI);
        this.addEventListener('enterframe', function(){
            if(player.within(this, 8)){     // Game Over if player is hit by bullet
                     game.end(game.score, "SCORE: " + game.score);
                }
        });
    }
});

window.onload = function() {
    game = new Core(320, 320);
    //Game Properties
    game.fps = 24; 
    game.score = 0;
    game.preload('graphic.png');
    game.touched = false;

    game.onload = function() {
        //In-Game Variables and Properties
        game.rootScene.backgroundColor = 'black';
        scoreLabel = new ScoreLabel(8, 8);
        game.rootScene.addChild(scoreLabel);
        player = new Player(0, 152);
        enemies = [];
        
        game.rootScene.addEventListener('enterframe', function(){
            if(Math.random()*100 <10){
                var y = Math.random() * 320;
                var enemy = new Enemy(320, y);
                enemy.key = game.frame;
                enemies[game.frame] = enemy;
            }
            scoreLabel.score = game.score;
        });
        
        
    };
    game.start();
};