enchant();
var stageHeight = 320;
var stageWidth = 320;
var moveSpeed = 5;
var player;

//Projectile Class
Projectile = Class.create(Sprite, {
    initialize: function() {
        Sprite.call(this, 16, 16);
        this.image = game.assets['icon0.png'];
        this.x = stageWidth;
        this.y = Math.random() * stageHeight;
        if(this.y <= 50){
            this.y = 50;
        }
        this.scaleX = -1.0;
        this.frame = 54;
    },

    onenterframe: function() {
        this.x -= 5;
        if(this.within(player, 15)){
            player.countDown = 15;
            player.health--;
            this.scene.removeChild(this);
        }
        
        if (this.x >= stageWidth) {
            this.scene.removeChild(this);
        }
    }
});

//Player Class
Player = Class.create(Sprite, {
    initialize: function() {
        Sprite.call(this, 32, 32);
        this.image = game.assets['space3.png'];
        this.x = 0;
        this.y = stageHeight / 2;
        this.frame = 15;
        this.countDown = 0;
        this.health = 5;
    },

    onenterframe: function() {

        if (this.countDown > 0) {
            this.frame = 18;
            this.countDown--;
            if (this.age % 2 === 0) {
                this.opacity = 0;
            } 
            else {
                this.opacity = 1;
            }
        } 
        else {
            this.opacity = 1;
            this.frame = 15;
            
       		if (game.input.left && !game.input.right) {
            	this.x -= moveSpeed;
        	} 
            else if (game.input.right && !game.input.left) {
                this.x += moveSpeed;
            }
            if (game.input.up && !game.input.down) {
                this.y -= moveSpeed;
            } 
            else if (game.input.down && !game.input.up) {
                this.y += moveSpeed;
            }
    	}
    }
});


window.onload = function() {
    game = new Game(stageHeight, stageWidth);
    game.preload('icon0.png', 'bg.png', 'space3.png');
    game.onload = function() {

        var bg = new Sprite(stageHeight, stageWidth);
        bg.image = game.assets['bg.png'];
        game.rootScene.addChild(bg);
        
        player = new Player();
        game.rootScene.addChild(player);
        
        var healthLabel = new Label("Health: " + player.health);
        healthLabel.color = "white";
        healthLabel.addEventListener('enterframe', function(){
            healthLabel.text = "Health: " + player.health;
        });
        
        game.rootScene.addChild(healthLabel);
        
        var timerLabel = new Label("Time: " + 300);
		timerLabel.color = "white";
        timerLabel.addEventListener('enterframe', function(){
            if(player.age <= 300){
        		timerLabel.text = "Time: " + (300 - player.age);
            }
            else{
                timerLabel.text = "Time: 0";
            }
        });
        
        timerLabel.x = 3* stageWidth / 4;
        game.rootScene.addChild(timerLabel);
        
        //08.1 Enterframe Function
    }
    game.start();
}