enchant();

var stageWidth = 320;
var stageHeight = 320;

//Player Class
Player = Class.create(Sprite, {
    initialize: function(){
        Sprite.call(this, 32, 32);
        this.image = game.assets['space3.png'];
        this.x = stageWidth/2 - this.width/2;
        this.y = 225;
        this.frame = 15;
    },
    
    onenterframe: function(){
        if(this.age >= 50){
            this.frame = 18;
        }
        if(this.age >= 60){
            game.popScene(this.scene);
        }
    }
});

//Button Class
Button = Class.create(Sprite, {
    initialize: function(whichButton){
        Sprite.call(this, 150, 50);
        this.image = game.assets['button-sheet.png'];
        this.x = stageWidth/2 - this.width/2;
        this.y = 3 * stageHeight/4;
        this.choice = whichButton;
        
        if(this.choice === 0){
            this.frame = 0;
        }
        else{
            this.frame = 1;
        }
    }, 
    
    ontouchend: function(){
        if(this.choice === 0){
            var gameScene = new GameScene();
            game.replaceScene(gameScene);
        }
        else if(this.choice === 1){
            var titleScene = new TitleScene();
            game.pushScene(titleScene);
        }
    }
});

//07.3 Title Scene Class

//07.3 Game Scene

//07.3 GameOver Scene Class

window.onload = function() {
    game = new Game(stageWidth, stageHeight);
    game.preload('space3.png', 'scene-gamebg.png', 'scene-gameover.png', 'scene-title.png', 'button-sheet.png');
    game.onload = function(){
        
       	//07.3 Initialize Scenes
    }
    game.start();
}