enchant();

var stageWidth = 320;
var stageHeight = 320;
var player;

//Projectile Class
Projectile = Class.create(Sprite, {
    initialize: function(){
        Sprite.call(this, 16, 16);
        this.image = game.assets['icon0.png'];
        this.x = stageWidth;
        this.y = stageHeight/2;
        this.frame = 50;
    },
    
    onenterframe: function(){
        this.x -= 4;
        
        //06.2 Intersect
        
        //06.3 Within
    }
});

//Player Class
Player = Class.create(Sprite, {
    initialize: function(){
    	Sprite.call(this, 32, 32);
    	this.image = game.assets['chara1.png'];
    	this.x = stageWidth/4;
    	this.y = stageHeight/2;
        this.frame = 5;
        this.countDown = 0;
    },
    
    onenterframe: function(){
        if(this.countDown > 0){
            this.countDown--;
            this.frame = 8
        }
        else{
            this.frame = 5;
        }
    }
});

window.onload = function() {
    game = new Game(stageWidth, stageHeight);
    game.preload('chara1.png', 'icon0.png');
    game.onload = function(){
        
        //Add player
        player = new Player();
        game.rootScene.addChild(player);
        
        //Add projectile spawner
        game.rootScene.addEventListener('enterframe', function(){
        	if(player.age % 45 === 0){
                var p = new Projectile();
                game.rootScene.addChild(p);
            }
        })
            
        
    }
    game.start();
}