//initialization of enchant.js
enchant();

//code written here will be executed once the HTML file is completely loaded
window.onload = function() {
    //game object creation
    var game = new Game(320, 320);
    
    //image loading
    game.preload('chara1.gif');
    
    //execution once the image has loaded completely
    game.onload = function() {
        //Sprite creation
        var bear = new Sprite(32, 32);
        bear.image = game.assets['chara1.gif'];
        bear.frame=4;
        
        //frame loop to move the bear every frame
        bear.addEventListener(Event.ENTER_FRAME, function() {
            this.x += 3; //move by 3 pixels
        });
        
        //add the bear to the display object tree
        game.rootScene.addChild(bear); 
    };
    game.start();
};