enchant(); //enchant.jsを使い始めるためのおまじない

TTweet = enchant.Class.create(enchant.Sprite, {
    initialize : function(w, h) {
        enchant.Sprite.call(this, w, h + TTweet.TAIL);
        this.image = new Surface(w, h + TTweet.TAIL);
        var t = TTweet.TAIL;
        var s = TTweet.SIZE;
        var c = TTweet.CURVE;
        this.outCurve = {
            lt : {x:  0, y:  t},
            rt : {x:  w, y:  t},
            rd : {x:  w, y:h+t},
            ld : {x:  0, y:h+t}
        };
        this.inCurve = {
            lt : {x:  0+s, y:  t+s},
            rt : {x:  w-s, y:  t+s},
            rd : {x:  w-s, y:h+t-s},
            ld : {x:  0+s, y:h+t-s}
        };
        this.reDraw();
    },
    reDraw : function() {
        var c = TTweet.CURVE;
        var o = this.outCurve;
        with(this.image.context) {
            fillStyle = 'black';
            strokeStyle = 'black';
            beginPath();
            moveTo(o.lt.x, o.lt.y+c);
            quadraticCurveTo(o.lt.x, o.lt.y, o.lt.x+c, o.lt.y);
            // しっぽ
            lineTo(this.width/2-4,TTweet.TAIL);
            lineTo(this.width/2,0);
            lineTo(this.width/2+4,TTweet.TAIL);
            lineTo(o.rt.x-c, o.rt.y);
            quadraticCurveTo(o.rt.x, o.rt.y, o.rt.x, o.rt.y+c);
            lineTo(o.rd.x, o.rd.y-c);
            quadraticCurveTo(o.rd.x, o.rd.y, o.rd.x-c, o.rd.y);
            lineTo(o.ld.x+c, o.ld.y);
            quadraticCurveTo(o.ld.x, o.ld.y, o.ld.x, o.ld.y-c);
            closePath();
            fill();
            stroke();
        };
        this.clear();
    },
    clear : function() {
        var c = TTweet.CURVE;
        var o = this.outCurve;
        var i = this.inCurve;
        with(this.image.context) {
            // 抜く
	        fillStyle = 'white';
            beginPath();
            moveTo(i.lt.x, o.lt.y+c);
            quadraticCurveTo(i.lt.x, i.lt.y, o.lt.x+c, i.lt.y);
            lineTo(o.rt.x-c, i.rt.y);
            quadraticCurveTo(i.rt.x, i.rt.y, i.rt.x, o.rt.y+c);
            lineTo(i.rd.x, o.rd.y-c);
            quadraticCurveTo(i.rd.x, i.rd.y, o.rd.x-c, i.rd.y);
            lineTo(o.ld.x+c, i.ld.y);
            quadraticCurveTo(i.ld.x, i.ld.y, i.ld.x, o.ld.y-c);
            closePath();
            fill();
        };
    },
    text : function(text) {
        this.clear();
        with(this.image.context) {
	        fillStyle = 'black';
            textAlign = 'center';
            textBaseline = 'middle';
            fillText(text,this.width/2,this.height/2);
        };
    }
});
TTweet.TAIL  =  8;
TTweet.SIZE  =  2;
TTweet.CURVE = 16;


window.onload = function() {
    game = new Game();
    game.onload = function() { //ここでゲームを開始する前の準備をする
        
        var tweet = new TTweet(128, 64);
        tweet.text("ABCDEFG");
        game.rootScene.addChild(tweet);
    }
    game.start(); //ゲーム開始
};