// キー入力対策
window.focus();

// グローバル変数
// ①　変数gameをグローバル化　ここでnewはできないので注意
var game;

// ②　enchant.jsで定義されてないキー入力処理を追加する。
document.onkeyup = function (e) {
    game.keyflg = false;    // gameオブジェクトにオリジナルのメンバ変数keyflgを追加
    console.log("keyup!!"); // キーが離された確認用console.log
    return true;
};

// enchant.jsを利用するときには必ず最初に書く
enchant();

// ページが読み込まれたときに実行される処理
window.onload = function()
{
    /*var */game = new Game(320, 320);  // ③　varを消す
    game.keyflg = false;    // ④初期値をtrueにするとキー入力の一回目に反応しない
        
    game.fps = 15;
    game.preload('bg1.png','bg2.png','chara1.png');
    
    // ゲームの処理
    game.onload = function()
    {
        // 背景用の画像を表示する
        var bgA = new Sprite(320,320);
        bgA.image = game.assets['bg1.png'];
        game.rootScene.addChild(bgA);
        
        var kuma=new Sprite(32,32);
        kuma.image=game.assets['chara1.png'];
        kuma.frame=1;
        kuma.x=60;
        kuma.y=230;
        game.rootScene.addChild(kuma);
        

        // 定期処理　背景スクロール
        game.rootScene.addEventListener('enterframe', function()
        {    
            if(game.input.right)
            {
               kuma.x+=2;
            }
            if(game.input.left)
            {
               kuma.x-=2;
            }
            if(game.input.up)
            {
                // ⑤上向き矢印が入力されかつgame.keyflgがfalseのとき
                if(!game.keyflg)
                {
                   kuma.tl.moveBy(0,-120,12).moveBy(0,120,12);
                   // ⑥game.keyflgをtrueに戻しておく
                   game.keyflg = true;
                }
            }
        });
        
        // クマをクリック
        kuma.addEventListener('touchend',function(e){
            kuma.tl.moveBy(0,-120,12).moveBy(0,120,12);
        });
    };
        
    // ゲームの処理をスタート
    game.start();
  
};

