enchant();

window.onload = () => {
  const game = new Core(320,320);
  game.fps = 15;
  game.preload("chara1.png");
  
  let score = 0;
  let timeLeft = 5 * game.fps;

  game.onload = () => {
    const bear = new Sprite(32,32);
    bear.image= game.assets["chara1.png"];
    bear.x=rand(320);
    bear.y=rand(320);
    bear.frame=0;

    bear.addEventListener("touchstart",function(){
      score++;
      scoreLabel.text = "Score: "+score;
      this.frame = 3;
      this.x=rand(300);
      this.y=rand(300);
    });

    const scoreLabel = new Label('Score: 0')
    scoreLabel.x = 200;
    scoreLabel.y = 5;

    const timeLabel = new Label('Time: 0')
    timeLabel.x = 80;
    timeLabel.y = 5;

    const gameOver = new Label()
    gameOver.x = 120;
    gameOver.y = 160;

    game.addEventListener("enterframe", function(){
        timeLeft--;
        timeLabel.text = 'Time: '+timeLeft;
        if(timeLeft<=0){
          gameOver.text = 'Your Score: ' + score;
          this.stop();
        }
    });

    game.rootScene.addChild(scoreLabel);
    game.rootScene.addChild(timeLabel);
    game.rootScene.addChild(gameOver);
    game.rootScene.addChild(bear);
  }
  game.start();
}


function rand(n){
  return Math.floor(Math.random()*(n+1));
}