enchant();

// Here we build a class from scratch to create the bear
Bear = Class.create(Sprite, // We extend the Sprite class
{
    initialize: function(x, y) { //initialization
        Sprite.call(this, 32, 32); //initialization of the Sprite object
        this.image = game.assets['chara1.gif'];
        this.x = x;
        this.y = y;
        this.frame = 0;
        game.rootScene.addChild(this);
    },
    //define the onenterframe eventlistener (run every frame)
    onenterframe: function() {
        this.x++; //move to the right
    },
    //define the ontouchend event listener (when the user lifts finger/finishes clicking on the bear)
    ontouchend: function() {
        this.frame += 3; //switch to frame of crying bear
    }
});

window.onload = function() {
    game = new Game(320, 320);
    game.preload('chara1.gif');
    game.onload = function() {
        bear1 = new Bear(10, 100); // first bear
        bear2 = new Bear(40, 110); // second bear
        bear3 = new Bear(0, 120); // third bear
    }
    game.start();
}