enchant(); //enchant.jsを使い始めるためのおまじない
window.onload = function() {
    game = new Game(320, 320);
    game.preload('icon1.png', 'map2.gif','enchant_normal.png');
    game.onload = function() { //ここでゲームを開始する前の準備をする
        //物理世界を創造する
        world = new PhysicsWorld(0.0, 9.8);
        //床を設置する
        //サイズは320*16　中心座標160,312
        floor = new PhyBoxSprite(320, 16, enchant.box2d.STATIC_SPRITE, 1.0, 0.5, 0.0, true);
        floor.image = new Surface(16, 16);
        floor.image.draw(game.assets['map2.gif'],0,0,16,16,0,0,16,16);
        floor.position = {x:160, y:312};
        game.rootScene.addChild(floor);
        //建物{w:width, h:height, x:xpoint, y:ypoint}
        //物理シュミレートはfalseにしておいた方が融通がきくと思います
        blocks = [
			{w:4, h:1, x:240, y:205},
			{w:1, h:2, x:240, y:222},
			{w:1, h:2, x:288, y:222},
			{w:3, h:1, x:208, y:255},
			{w:3, h:1, x:256, y:255},
			{w:1, h:2, x:208, y:272},
			{w:1, h:2, x:288, y:272}
        ];
        // 豆腐
        for (var i = 0; i < blocks.length; i++) {
            var block = new PhyBoxSprite(16 * blocks[i].w, 16 * blocks[i].h, enchant.box2d.DYNAMIC_SPRITE, 1.0, 0.5, 0.0, false);
            block.image = new Surface(16 * blocks[i].w, 16 * blocks[i].h);
            //block.image.draw(game.assets['map2.gif'],16,0,16,16,0,0,16,16);
            block.x = blocks[i].x;
            block.y = blocks[i].y;
            block.image.context.strokeRect(0,0,16 * blocks[i].w, 16 * blocks[i].h);
            game.rootScene.addChild(block);
        }
        //カラーボールを置く{x:xpoint, y:ypoint, c:color}
        //物理シュミレートはfalseにしておいた方が融通がきくと思います
        var balls = [
            {x:272, y:188, c:2},
            {x:264, y:237, c:3},
            {x:216, y:237, c:4},
            {x:256, y:288, c:5}
        ];
        // こんにゃく
        for (var i = 0; i < balls.length; i++) {
            var ball = new PhyCircleSprite(8, enchant.box2d.DYNAMIC_SPRITE, 1.0, 0.5, 0.8, false);
            ball.image = game.assets['icon1.png'];
//            ball.image = new Surface(16,16);
//            ball.image.context.
            ball.frame = 5;
            ball.x = balls[i].x;
            ball.y = balls[i].y;
            game.rootScene.addChild(ball);
        }
        //餃子
        
        //弾を置く
        bullet = new PhyCircleSprite(8, enchant.box2d.DYNAMIC_SPRITE, 1.0, 0.5, 0.8, true);
        //bullet.image = game.assets['enchant_normal.png'];
        bullet.image = new Surface(16,16);
        bullet.image.draw(game.assets['enchant_normal.png'],0,0,48,48,0,0,16,16);
        bullet.frame = 0;
        bullet.position = {x:48, y:296};
        game.rootScene.addChild(bullet);
        //弾を弾く処理
        //y軸への補正は-3くらいが妥当ではないかと思います
        bullet.addEventListener(Event.TOUCH_END, function(e) {
            // 昔なつかし三角関数
            p = this.position;
            h = Math.sqrt(Math.pow(e.x - p.x, 2) + Math.pow(e.y - p.y, 2));
            a = (e.x - p.x) / h;
            b = (e.y - p.y) / h;
            // 条件によっては a、b を求められない場合があるので、その場合は 0 に変更する
            a = isNaN(a) ? 0 : a;
            b = isNaN(b) ? 0 : b;
            // applyImpulse は瞬発力をオブジェクトに加える関数
            // b2Vec2 は box2d で扱うベクトル
            this.applyImpulse(new b2Vec2(-1 * a, -3 * b));
        });
        game.rootScene.onenterframe = function(e) {
            //物理世界の時間を進める
            world.step(game.fps);
        };
    }
    game.start(); //ゲーム開始
}