enchant();
var game;
window.onload = function() {
    game = new Game(320, 320);
    
    var map=[]
    for(z=0;z<25;z++){
        map[z]=[]
	    for(x=0;x<25;x++){
	    	map[z][x]=Math.sin(x*0.5)+3+Math.sin(z*0.5)+Math.random()
	    }
    }
    
    function getColor(a){
    	var r=0,g=0,b=0
    	if(a<0.66)b=a*3
    	if(a<0.80)g=(a-0.33)*3
    	if(a>0.80)r=(a-0.66)*3
    	if(r>1.0)r=1.0
    	if(g>1.0)g=1.0
    	if(b>1.0)b=1.0
    	return [r,g,b,1.0]
    }
    
    game.onload = function() {
        var scene = new Scene3D();

        var center = new PlaneXZ();
        center.z = -40;
        center.mesh.setBaseColor([0,0,0,0]);
        scene.addChild(center);
        
        var graph=[];

	    for(z=0;z<25;z++){
	    	graph[z]=[]
	   		for(x=0;x<25;x++){
	   			var p = new Cube()
	   			p.x=x-25/2
	   			p.z=z-25/2
	   			p.scaleY=map[z][x]
	   			p.y = map[z][x]*0.5
	   			p.addEventListener('enterframe',function(){
		   			this.mesh.setBaseColor(getColor(this.y/3));
	   			})
	   			graph[z][x]=p;
	   			center.addChild(p)
	   		 }
	    }	
	   
	   	center.addEventListener('enterframe',function(){
		    for(z=0;z<25;z++){
			    for(x=0;x<25;x++){
			    	graph[z][x].y+=Math.sin(x*0.3+this.age*0.1)*0.05+Math.cos(z*0.3+this.age*0.1)*0.01
       			    graph[z][x].scaleY=graph[z][x].y*2

			    }
		    }
	   	})
        
        center.rotateYaw( -0.5 ); // ヨー軸まわりの回転を行う
        center.rotatePitch( -0.5 );
             
        game.rootScene.addEventListener('touchstart',function(e){ //rootSceneのtouchstartイベントを設定
             tempEv = e;
       });

       game.rootScene.addEventListener('touchmove',function(e){ //rootSceneのtouchmoveイベントを設定

             center.rotateYaw( (e.x - tempEv.x)*0.01 ); // ヨー軸まわりの回転を行う
             center.rotatePitch( (e.y - tempEv.y)*0.01 ); // ピッチ軸まわりの回転を行う

             tempEv = e;
       });
    };
    game.start();
};
