enchant();

// ここで自作クラスBearをつくる
Bear = Class.create(Sprite, // Spriteクラスを継承
{
    initialize: function(x, y) { //初期化する
        Sprite.call(this, 32, 32); //Spriteオブジェクトを初期化
        this.image = game.assets['chara1.gif'];
        this.x = x;
        this.y = y;

        this.tx = this.x; //行きたい場所のX座標
        this.ty = this.y; //行きたい場所のY座標
        this.frame = 0;
        game.rootScene.addChild(this);
    },
    //enterframeイベントのリスナーを定義する
    onenterframe: function() {
        slow = 30; //クマが行きたい場所へ近づく遅さ
        //行きたい場所へ近づく
        this.x += (this.tx - this.x) / slow;
        this.y += (this.ty - this.y) / slow;

    }
});


//フルーツのためのクラス
Fruits = Class.create(Sprite, // Spriteクラスを継承
{
    initialize: function(frame) { //初期化する
        Sprite.call(this, 16, 16); //Spriteオブジェクトを初期化
        this.image = game.assets['icon0.gif'];

        // ランダムな場所にフルーツを表示する
        this.x = Math.random() * 320; // Math.random()を使うと0から1未満の
        this.y = Math.random() * 320; // ランダムな少数が得られるのでそれで座標をつくる
        this.frame = frame;
        game.rootScene.addChild(this);
    },
    onenterframe: function() {
        if (this.within(bear)) {
            // 自分自身(フルーツ)を画面から消す
            game.rootScene.removeChild(this);
            score++; //スコアを1足す
        }
    }
});

window.onload = function() {
    game = new Game(320, 320);
    game.preload('chara1.gif', 'icon0.gif');
    game.onload = function() {
        bear = new Bear(150, 150); // クマさんをつくる
        for (i = 0; i < 10; i++) {
            fruits = new Fruits(15); // 15番(りんご)を表示
        }

        score = 0; //点数をリセット
        //ゲーム画面のどこかをタッチした時の処理
        game.rootScene.addEventListener('touchend', function(event) { //eventにタッチされた座標が入ってくる
            bear.tx = event.x; //クマの「行きたい場所」にタッチされたX座標を指定
            bear.ty = event.y; //クマの「行きたい場所」にタッチされたY座標を指定
        });


    }
    game.start();
}